#ifndef __CDiskPathMenuItem__
#define __CDiskPathMenuItem__

#include "CMenuItem.hpp"
#include "CMenu.hpp"

//	===========================================================================

using Exponent::GUI::Controls::CMenuItem;
using Exponent::GUI::Controls::CMenu;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Controls
		{
			/**
			 * @class CDiskPathMenuItem CDiskPathMenuItem.hpp
			 * @brief Menu item that represents a file on the disk
			 *
			 * @date 25/05/2005
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: CDiskPathMenuItem.hpp,v 1.4 2007/02/08 21:07:54 paul Exp $
			 */
			class CDiskPathMenuItem : public CMenuItem
			{
				/** @cond */
				EXPONENT_CLASS_DECLARATION;
				/** @endcond */

//	===========================================================================
		
			public:

//	===========================================================================

				/**
				 * Construction
				 * @param path The path to the file
				 * @param text The string representing the file
				 * @param identifier A unique id
				 * @param type The type of menu item
				 * @param enabled If true the menu is enabled, if false user cannot use it
				 * @see CMenuItem
				 */
				CDiskPathMenuItem(const CSystemString &path, const CString &text, const long identifier, const EMenuItemTypes type, const bool enabled = true);

				/**
				 * Destruction
				 */
				virtual ~CDiskPathMenuItem();

//	===========================================================================

				/** 
				 * Get the path to the item
				 * @retval const CSystemString& The path to the file
				 */
				const CSystemString &getPath() const { return m_path; }

//	===========================================================================

				/**
				 * Traverse disk path (gets called recursively)
				 * @param path The current path, expects a full starting path
				 * @param menuToAddTo The menu that the items should be added to
				 * @param extension Any specified extension that you would like to use
				 */
				static void traverseDiskPath(const CSystemString &path, CMenu *menuToAddTo, const CString &extension);

//	===========================================================================

			protected:

//	===========================================================================

				CSystemString m_path;			/**< The full path to the item */
			};
		}
	}
}
#endif	// End of CDiskPathMenuItem.hpp